#ifndef MSG_DEFS_H
#define MSG_DEFS_H

/*
   *  Object          : msg_defs.h
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:26:15 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief this file containes the definitions for the HOST-SEP protocl.
   *         
   *
   *  \version msg_def.h#1:csrc:3
   *  \author avis
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
/************************ Defines ******************************/
/*HOST_SEP protocol messgaes*/
#define	DX_SEP_HOST_SEP_MSG_START_TOKEN					0X2558808

/* general definitions */
#define DX_SEP_HOST_SEP_PROTOCOL_MSG_TOKEN_OFFSET		0
#define DX_SEP_HOST_SEP_PROTOCOL_MSG_LEN_OFFSET		    1
#define DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET		2

/* In all returned messages RC is returned in this offset */
#define DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET			3

/*HOST_SEP offset message for 3rd party application */
#define DX_SEP_HOST_SEP_BASE_MSG_OFFSET					3

/* error message with only rc */
#define DX_SEP_HOST_SEP_PROTOCOL_ERR_MSG_LENGTH_IN_BYTES	20		
#define DX_SEP_HOST_SEP_PROTOCOL_ERR_MSG_LENGTH_IN_WORDS	5			
#define DX_SEP_HOST_SEP_PROTOCOL_ERR_MSG_LENGTH				DX_SEP_HOST_SEP_PROTOCOL_ERR_MSG_LENGTH_IN_BYTES		
#define DX_SEP_HOST_SEP_PROTOCOL_ERR_MSG_CS_OFFSET			4


/****************************************************************************/
/****************************************************************************/

/* HOST INIT COMMAND */
#define DX_SEP_HOST_SEP_PROTOCOL_MSG_HOST_BASE_ADDRESS_OFFSET			3
#define DX_SEP_HOST_SEP_PROTOCOL_MSG_SHARED_AREA_ADDRESS_OFFSET			4
#define DX_SEP_HOST_SEP_PROTOCOL_MSG_SHARED_AREA_SIZE_OFFSET			5
#define DX_SEP_HOST_SEP_PROTOCOL_MSG_RESIDENT_ADDRESS_OFFSET			6
#define DX_SEP_HOST_SEP_PROTOCOL_MSG_CACHE_ADDRESS_OFFSET				7
#define DX_SEP_HOST_SEP_PROTOCOL_MSG_CACHE_SIZE_OFFSET					8
/************************ Enums ******************************/

/*This define is used for the prng and drng limits*/
#define DX_SEP_HOST_SEP_MAX_VECTOR_LENGTH												0x1000
/************************ Typedefs ******************************/


/************************ Global Data ******************************/


/************* Private function prototypes ****************/
#endif

